library(stockassessment)
load("run/model.RData")
FC<-list()
Ry<-2013:2023
set.seed(12345)
FC[[length(FC)+1]] <- forecast(fit, fscale=c(1,1,1,1), rec.years=Ry, processNoiseF = FALSE, label="SQ all years", addTSB=TRUE)

set.seed(12345)
FC[[length(FC)+1]] <- forecast(fit, fscale=c(1,NA,NA,NA), fval=c(NA,0.000001,0.000001, 0.000001), rec.years=Ry, processNoiseF = FALSE,  label="SQ then zero F", addTSB=TRUE)

set.seed(12345)
FC[[length(FC)+1]] <- forecast(fit, fscale=c(1,NA,NA,NA), fval=c(NA,0.69,0.69, 0.69), rec.years=Ry, processNoiseF = FALSE, label="SQ then Fpa", addTSB=TRUE)

set.seed(12345)
FC[[length(FC)+1]] <- forecast(fit, fscale=c(1,NA,NA,NA), fval=c(NA,1.47, 1.47, 1.47), rec.years=Ry, processNoiseF = FALSE, label="SQ then Flim", addTSB=TRUE)

set.seed(12345)
FC[[length(FC)+1]] <- forecast(fit, fscale=c(1,NA,NA,NA), fval=c(NA, 0.37, 0.37, 0.37), rec.years=Ry, processNoiseF = FALSE, label="SQ then Fmsy", addTSB=TRUE)


Fmsyadvice<-0.37*24739/24739


set.seed(12345)
FC[[length(FC)+1]] <- forecast(fit, fscale=c(1,NA,NA,NA), fval=c(NA, Fmsyadvice, Fmsyadvice, Fmsyadvice), rec.years=Ry, processNoiseF = FALSE, label="SQ then Fmsyadvice", addTSB=TRUE)


save(FC, file="run/forecast.RData")



#Usage:
#
#     forecast(
#       fit,
#       fscale = NULL,
#       catchval = NULL,
#       catchval.exact = NULL,
#       fval = NULL,
#       nextssb = NULL,
#       landval = NULL,
#       cwF = NULL,
#       nosim = 1000,
#       year.base = max(fit$data$years),
#       ave.years = max(fit$data$years) + (-4:0),
#       rec.years = max(fit$data$years) + (-9:0),
#       label = NULL,
#       overwriteSelYears = NULL,
#       deterministic = FALSE,
#       processNoiseF = TRUE,
#       customWeights = NULL,
#       customSel = NULL,
#       lagR = FALSE,
#       splitLD = FALSE,
#       addTSB = FALSE,
#       useSWmodel = (fit$conf$stockWeightModel == 1),
#       useCWmodel = (fit$conf$catchWeightModel == 1),
#       useMOmodel = (fit$conf$matureModel == 1),
#       useNMmodel = (fit$conf$mortalityModel == 1),
#       savesim = FALSE
#     )
