library(stockassessment)
setwd("data")

cn<-read.ices("cn.dat")
cw<-read.ices("cw.dat")
dw<-read.ices("dw.dat")
lw<-read.ices("lw.dat")
mo<-read.ices("mo.dat")
nm<-read.ices("nm.dat")

#nm[nrow(nm)-c(0:5),]<-0.4

pf<-read.ices("pf.dat")
pm<-read.ices("pm.dat")
sw<-read.ices("sw.dat")
lf<-read.ices("lf.dat")

surveys<-read.ices("survey.dat")

#W<-matrix(1, nrow=nrow(surveys[[1]]), ncol=ncol(surveys[[1]])); W[nrow(surveys[[1]])+c(0,-1,-2,-3,-4),]<-0.01; attr(surveys[[1]],"weight")<-W

setwd("..")

dat<-setup.sam.data(surveys=surveys,
                    residual.fleet=cn, 
                    prop.mature=mo, 
                    stock.mean.weight=sw, 
                    catch.mean.weight=cw, 
                    dis.mean.weight=dw, 
                    land.mean.weight=lw,
                    prop.f=pf, 
                    prop.m=pm, 
                    natural.mortality=nm, 
                    land.frac=lf)


save(dat, file="run/data.RData")
